/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Service
public class UserService {
    private final String clientRegistrationId;

    public UserService(@Autowired(required=false) InMemoryClientRegistrationRepository clientRegistrationRepository) {
        this.clientRegistrationId = clientRegistrationRepository != null ? ((ClientRegistration)clientRegistrationRepository.iterator().next()).getRegistrationId() : null;
    }

    public String getLoginPath() {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path("/oauth2/authorization").path("/").path(this.clientRegistrationId).build().getPath();
    }

    public String getLoginUrl() {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path("/oauth2/authorization").path("/").path(this.clientRegistrationId).build().toString();
    }

    public boolean isAuthenticated() {
        Authentication user = SecurityContextHolder.getContext().getAuthentication();
        return !(user instanceof AnonymousAuthenticationToken);
    }

    public Authentication getUser() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public boolean isMember(Authentication auth, String group) {
        for (GrantedAuthority grantedAuth : auth.getAuthorities()) {
            String groupName = grantedAuth.getAuthority().toUpperCase();
            if (groupName.startsWith("ROLE_")) {
                groupName = groupName.substring(5);
            }
            if (!groupName.equalsIgnoreCase(group)) continue;
            return true;
        }
        return false;
    }
}

