/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.service;

import eu.openanalytics.crane.model.config.Repository;
import eu.openanalytics.crane.model.runtime.CraneDirectory;
import eu.openanalytics.crane.model.runtime.CraneFile;
import eu.openanalytics.crane.model.runtime.CraneResource;
import eu.openanalytics.crane.service.PathReadAccessControlService;
import eu.openanalytics.crane.service.PosixReadAccessControlService;
import eu.openanalytics.crane.upload.PathWriteAccessControlService;
import eu.openanalytics.crane.upload.PosixWriteAccessControlService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;

@Service
public class IndexPageService {
    private final PathReadAccessControlService pathReadAccessControlService;
    private final PosixReadAccessControlService posixReadAccessControlService;
    private final PathWriteAccessControlService pathWriteAccessControlService;
    private final PosixWriteAccessControlService posixWriteAccessControlService;

    public IndexPageService(PathReadAccessControlService pathReadAccessControlService, PosixReadAccessControlService posixReadAccessControlService, PathWriteAccessControlService pathWriteAccessControlService, PosixWriteAccessControlService posixWriteAccessControlService) {
        this.pathReadAccessControlService = pathReadAccessControlService;
        this.posixReadAccessControlService = posixReadAccessControlService;
        this.pathWriteAccessControlService = pathWriteAccessControlService;
        this.posixWriteAccessControlService = posixWriteAccessControlService;
    }

    public String getTemplateName(Repository repository) {
        return "default-index";
    }

    public Map<String, Object> getTemplateVariables(Repository repository, Path path) throws IOException {
        Path current;
        ArrayList craneFiles = new ArrayList();
        ArrayList craneDirectories = new ArrayList();
        try (Stream<Path> dirListing = Files.list(path);){
            dirListing.forEach(p -> {
                CraneResource craneResource = CraneResource.createFromPath((Path)p, (Repository)repository);
                if (craneResource == null) {
                    return;
                }
                String fullPath = p.toString().substring(repository.getStorageLocation().length());
                if (this.pathReadAccessControlService.canAccess(repository, fullPath) && this.posixReadAccessControlService.canAccess(repository, fullPath)) {
                    if (craneResource instanceof CraneFile) {
                        CraneFile craneFile = (CraneFile)craneResource;
                        craneFiles.add(craneFile);
                    } else if (craneResource instanceof CraneDirectory) {
                        CraneDirectory craneDirectory = (CraneDirectory)craneResource;
                        craneDirectories.add(craneDirectory);
                    }
                }
            });
        }
        boolean hasWriteAccess = this.pathWriteAccessControlService.canAccess(repository, path.toString()) && this.posixWriteAccessControlService.canAccess(repository, path.toString());
        ArrayList<CraneResource> breadcrumbs = new ArrayList<CraneResource>();
        CraneResource resource = CraneResource.createFromPath((Path)current, (Repository)repository);
        for (current = path; resource != null && current != null && !current.toString().equals(repository.getStoragePath().toString()); current = current.getParent()) {
            breadcrumbs.add(0, resource);
            resource = CraneResource.createFromPath((Path)current, (Repository)repository);
        }
        breadcrumbs.add(0, resource);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("files", craneFiles);
        map.put("directories", craneDirectories);
        map.put("hasWriteAccess", hasWriteAccess);
        map.put("breadcrumbs", breadcrumbs);
        return map;
    }
}

