/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.service;

import eu.openanalytics.crane.model.config.Repository;
import eu.openanalytics.crane.service.UserService;
import eu.openanalytics.crane.service.spel.SpecExpressionContext;
import eu.openanalytics.crane.service.spel.SpecExpressionResolver;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class HandleSpecExpressionService {
    private final UserService userService;
    private final SpecExpressionResolver specExpressionResolver;

    public HandleSpecExpressionService(UserService userService, SpecExpressionResolver specExpressionResolver) {
        this.userService = userService;
        this.specExpressionResolver = specExpressionResolver;
    }

    public boolean handleByOnErrorExpression(Repository repository, HttpServletRequest request, HttpServletResponse response, int errorStatus) {
        if (repository.getOnErrorExpression() == null) {
            return false;
        }
        response.setStatus(errorStatus);
        Authentication auth = this.userService.getUser();
        SpecExpressionContext context = SpecExpressionContext.create((Object[])new Object[]{auth, auth.getPrincipal(), auth.getCredentials(), repository, request, response});
        return this.specExpressionResolver.evaluateToBoolean(repository.getOnErrorExpression(), context);
    }
}

