/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security;

import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;

public class RedisOAuth2AuthorizedClientService
implements OAuth2AuthorizedClientService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RedisTemplate<String, OAuth2AuthorizedClient> redisTemplate;
    private String redisKey;
    private HashOperations<String, String, OAuth2AuthorizedClient> ops;

    public RedisOAuth2AuthorizedClientService(RedisTemplate<String, OAuth2AuthorizedClient> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @PostConstruct
    public void init() {
        this.redisKey = "shinyproxy_spring_oauth_authorized_clients__";
        this.ops = this.redisTemplate.opsForHash();
    }

    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, String principalName) {
        this.logger.debug("Load AuthorizedClient for {}", (Object)principalName);
        return (T)((OAuth2AuthorizedClient)this.ops.get((Object)(this.redisKey + "_" + clientRegistrationId), (Object)principalName));
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal) {
        this.logger.debug("Save AuthorizedClient for {}", (Object)principal.getName());
        this.ops.put((Object)(this.redisKey + "_" + authorizedClient.getClientRegistration().getRegistrationId()), (Object)principal.getName(), (Object)authorizedClient);
    }

    public void removeAuthorizedClient(String clientRegistrationId, String principalName) {
        this.logger.debug("Remove AuthorizedClient for {}", (Object)principalName);
        this.ops.delete((Object)(this.redisKey + "_" + clientRegistrationId), new Object[]{principalName});
    }
}

