/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security;

import eu.openanalytics.crane.security.CustomExceptionTranslationFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.util.MimeType;
import org.springframework.web.filter.GenericFilterBean;

public class CustomExceptionTranslationFilter
extends GenericFilterBean {
    private final ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();
    private final AccessDeniedHandler accessDeniedHandler = new AccessDeniedHandlerImpl();

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)ex);
            AccessDeniedException accessDeniedException = (AccessDeniedException)this.throwableAnalyzer.getFirstThrowableOfType(AccessDeniedException.class, causeChain);
            if (accessDeniedException == null) {
                throw ex;
            }
            String contentType = request.getHeader("Accept");
            if (contentType == null) {
                this.accessDeniedHandler.handle(request, response, accessDeniedException);
                return;
            }
            List mediaTypes = MediaType.parseMediaTypes((String)contentType);
            if (mediaTypes.stream().noneMatch(m -> m.equalsTypeAndSubtype((MimeType)MediaType.TEXT_HTML))) {
                this.accessDeniedHandler.handle(request, response, accessDeniedException);
                return;
            }
            throw ex;
        }
    }
}

