/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.security;

import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.security.OidcCraneUser;
import eu.openanalytics.crane.security.TokenParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class CraneOidcUserService
extends OidcUserService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TokenParser tokenParser;
    private final CraneConfig config;

    public CraneOidcUserService(TokenParser tokenParser, CraneConfig config) {
        this.tokenParser = tokenParser;
        this.config = config;
    }

    public OidcCraneUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser user;
        try {
            user = super.loadUser(userRequest);
        }
        catch (IllegalArgumentException ex) {
            this.logger.warn("Error while loading user info: {}", (Object)ex.getMessage());
            throw new OAuth2AuthenticationException(new OAuth2Error("invalid_request"), "Error while loading user info", (Throwable)ex);
        }
        catch (OAuth2AuthenticationException ex) {
            this.logger.warn("Error while loading user info: {}", (Object)ex.getMessage());
            throw ex;
        }
        return new OidcCraneUser(this.tokenParser.parseAuthorities(user.getClaims()), user.getIdToken(), user.getUserInfo(), this.tokenParser.parseUID(user.getClaims()), this.tokenParser.parseGIDS(user.getClaims()), this.config.getOpenidUsernameClaim());
    }
}

