/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.model.runtime;

import eu.openanalytics.crane.model.config.Repository;
import eu.openanalytics.crane.model.runtime.CraneDirectory;
import eu.openanalytics.crane.model.runtime.CraneFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public interface CraneResource {
    public static CraneResource createFromPath(Path path, Repository repository) {
        try {
            BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (attributes.isDirectory()) {
                return new CraneDirectory(path.getFileName().toString(), "/" + repository.getStoragePath().relativize(path));
            }
            return new CraneFile(path.getFileName().toString(), attributes.lastModifiedTime().toInstant(), Long.valueOf(attributes.size()));
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getName();
}

