/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.model.runtime;

import eu.openanalytics.crane.model.runtime.CraneResource;
import eu.openanalytics.crane.util.FileSize;
import java.time.Instant;

public class CraneFile
implements CraneResource {
    private final String name;
    private final Instant lastModifiedTime;
    private final Long size;
    private final String formattedSize;

    public CraneFile(String name, Instant lastModifiedTime, Long size) {
        this.name = name;
        this.lastModifiedTime = lastModifiedTime;
        this.size = size;
        this.formattedSize = FileSize.bytesToHumanReadableBinary((long)size);
    }

    public String getName() {
        return this.name;
    }

    public Instant getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Long getSize() {
        return this.size;
    }

    public String getFormattedSize() {
        return this.formattedSize;
    }
}

