/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.model.config;

import eu.openanalytics.crane.model.config.AccessControl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class PathComponent {
    private static final Pattern namePattern = Pattern.compile("^[a-zA-Z0-9_\\-]*$");
    private String name;
    private Map<String, PathComponent> components;
    private AccessControl readAccess = null;
    private AccessControl writeAccess = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccessControl getReadAccess() {
        return this.readAccess;
    }

    public void setReadAccess(AccessControl readAccess) {
        this.readAccess = readAccess;
    }

    public List<PathComponent> getPaths() {
        if (this.components != null) {
            return new ArrayList<PathComponent>(this.components.values());
        }
        return null;
    }

    public void setPaths(Map<String, PathComponent> paths) {
        paths.forEach((name, pathComponent) -> pathComponent.setName(name));
        this.components = paths;
    }

    public boolean hasPaths() {
        return this.components != null && !this.components.isEmpty();
    }

    public Optional<PathComponent> getPath(String name) {
        return Optional.ofNullable((PathComponent)this.components.get(name));
    }

    public void validate(boolean onlyPublic) {
        if (this.getName() == null) {
            throw new RuntimeException("PathComponent has no name");
        }
        if (!namePattern.matcher(this.getName()).matches()) {
            throw new RuntimeException(String.format("PathComponent name %s contains invalid characters", this.name));
        }
        if (this.readAccess == null && this.writeAccess == null) {
            throw new IllegalArgumentException(String.format("PathComponent %s is invalid: no access control specified", this.name));
        }
        this.validateReadAccess(onlyPublic);
        this.validateWriteAccess(onlyPublic);
        try {
            this.readAccess.validate();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("PathComponent %s has invalid read access control: %s", this.name, ex.getMessage()));
        }
        try {
            this.writeAccess.validate();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("PathComponent %s has invalid write access control: %s", this.name, ex.getMessage()));
        }
        if (this.components != null) {
            for (PathComponent component : this.components.values()) {
                component.validate(onlyPublic);
                if (component.readAccess.getPublic() && !this.readAccess.getPublic()) {
                    throw new IllegalArgumentException(String.format("PathComponent %s has invalid read access control: cannot have a public PathComponent (%s) in a private parent (%s)", component.name, component.name, this.name));
                }
                if (!component.writeAccess.getPublic() || this.writeAccess.getPublic()) continue;
                throw new IllegalArgumentException(String.format("PathComponent %s has invalid write access control: cannot have a public PathComponent (%s) in a private parent (%s)", component.name, component.name, this.name));
            }
        }
    }

    protected void validateReadAccess(boolean onlyPublic) {
        if (onlyPublic && this.readAccess != null && !this.readAccess.getPublic()) {
            throw new IllegalArgumentException("The repository `%s` should have public read access when the `only-public` property is `true`.".formatted(this.name));
        }
        if (this.readAccess == null) {
            this.readAccess = new AccessControl();
        }
    }

    protected void validateWriteAccess(boolean onlyPublic) {
        if (onlyPublic && this.writeAccess != null && !this.writeAccess.getPublic()) {
            throw new IllegalArgumentException("The repository `%s` should not have write access defined (or public) when the `only-public` property is `true`.".formatted(this.name));
        }
        if (this.writeAccess == null) {
            this.writeAccess = new AccessControl();
        }
    }

    public AccessControl getWriteAccess() {
        return this.writeAccess;
    }

    public void setWriteAccess(AccessControl writeAccess) {
        this.writeAccess = writeAccess;
    }
}

