/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.model.config;

import java.time.Duration;

public class CacheRule {
    private String pattern;
    private Duration maxAge;

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(String maxAge) {
    }

    public void setMaxAge(Duration maxAge) {
        if (maxAge.isNegative()) {
            throw new IllegalArgumentException("Incorrect configuration detected: the maxAge of a cache entry must be positive");
        }
        if (maxAge.compareTo(Duration.ofDays(365L)) > 0) {
            throw new IllegalArgumentException("Incorrect configuration detected: the maxAge of a cache entry may not be greater than one year");
        }
        this.maxAge = maxAge;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (!pattern.startsWith("/")) {
            throw new IllegalArgumentException("Incorrect configuration detected: the pattern of a cache entry must start with /");
        }
        this.pattern = pattern;
    }
}

