/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane.config;

import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.model.config.Repository;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.LinkedHashMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

@Configuration
public class RepositoryHostingConfig {
    private final CraneConfig config;
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();

    public RepositoryHostingConfig(CraneConfig config) {
        this.config = config;
    }

    @Bean
    public SimpleUrlHandlerMapping handler() {
        LinkedHashMap<String, HttpRequestHandler> urlMap = new LinkedHashMap<String, HttpRequestHandler>();
        for (Repository repository : this.config.getRepositories()) {
            urlMap.put(String.format("/%s/**", repository.getName()), (request, response) -> request.getRequestDispatcher("/__file" + this.urlPathHelper.getPathWithinApplication(request)).forward((ServletRequest)request, (ServletResponse)response));
        }
        return new SimpleUrlHandlerMapping(urlMap);
    }
}

