/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane;

import eu.openanalytics.crane.BaseUIController;
import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.model.config.Repository;
import eu.openanalytics.crane.model.dto.ApiResponse;
import eu.openanalytics.crane.service.IndexPageService;
import eu.openanalytics.crane.service.UserService;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IndexPageController
extends BaseUIController {
    private final IndexPageService indexPageService;

    public IndexPageController(IndexPageService indexPageService, UserService userService, CraneConfig craneConfig) {
        super(userService, craneConfig);
        this.indexPageService = indexPageService;
    }

    @GetMapping(value={"/__index"}, produces={"text/html"})
    public String main(ModelMap map, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Path path = (Path)request.getAttribute("path");
        Repository repo = (Repository)request.getAttribute("repo");
        if (path == null || repo == null) {
            request.setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.NOT_FOUND.value());
            request.getRequestDispatcher("/error").forward((ServletRequest)request, (ServletResponse)response);
            return null;
        }
        String resource = (String)request.getAttribute("jakarta.servlet.forward.servlet_path");
        resource = resource.replace(repo.getIndexFileName(), "");
        this.prepareMap(map);
        map.put((Object)"resource", (Object)resource);
        map.putAll(this.indexPageService.getTemplateVariables(repo, path));
        return this.indexPageService.getTemplateName(repo);
    }

    @ResponseBody
    @GetMapping(value={"/__index"}, produces={"application/json"})
    public ResponseEntity<ApiResponse<Map<String, Object>>> mainJson(HttpServletRequest request, HttpServletResponse response, CsrfToken csrfToken) throws IOException, ServletException {
        Path path = (Path)request.getAttribute("path");
        Repository repo = (Repository)request.getAttribute("repo");
        if (path == null || repo == null) {
            request.setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.NOT_FOUND.value());
            request.getRequestDispatcher("/error").forward((ServletRequest)request, (ServletResponse)response);
            return null;
        }
        Map variables = this.indexPageService.getTemplateVariables(repo, path);
        variables.keySet().retainAll(List.of("directories", "files"));
        variables.put(csrfToken.getHeaderName(), csrfToken.getToken());
        return ApiResponse.success((Object)variables);
    }
}

