/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.audit.AuditAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableAsync
@EnableWebMvc
@EnableMethodSecurity
@SpringBootApplication(exclude={RedisAutoConfiguration.class, AuditAutoConfiguration.class})
public class CraneApplication {
    private static final Path TERMINATION_LOG_FILE = Path.of("/dev/termination-log", new String[0]);

    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{CraneApplication.class});
        app.setDefaultProperties(CraneApplication.getDefaultProperties());
        try {
            app.run(args);
        }
        catch (Throwable t) {
            CraneApplication.handleError((Throwable)t);
        }
    }

    public static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.put("management.server.port", "9090");
        properties.put("management.health.ldap.enabled", (Object)false);
        properties.put("management.health.redis.enabled", (Object)false);
        properties.put("management.endpoint.health.probes.enabled", (Object)true);
        properties.put("spring.session.store-type", "none");
        properties.put("spring.main.log-startup-info", "false");
        properties.put("server.shutdown", "graceful");
        properties.put("spring.lifecycle.timeout-per-shutdown-phase", "60s");
        properties.put("spring.servlet.multipart.enabled", (Object)false);
        return properties;
    }

    private static void handleError(Throwable t) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)t);
        if (cause == null) {
            cause = t;
        }
        String message = "Crane crashed! Exception: '" + cause.getClass().getName() + "', message: '" + cause.getMessage() + "'";
        if (Files.exists(TERMINATION_LOG_FILE, new LinkOption[0]) && Files.isRegularFile(TERMINATION_LOG_FILE, new LinkOption[0])) {
            try {
                FileWriter fileWriter = new FileWriter(TERMINATION_LOG_FILE.toString());
                PrintWriter printWriter = new PrintWriter(fileWriter);
                printWriter.print(message);
                printWriter.close();
            }
            catch (Throwable ioException) {
                System.out.println("Error while writing termination log");
                ioException.printStackTrace();
            }
        }
        System.out.println();
        System.out.println(message);
        System.out.println();
        System.exit(1);
    }
}

