/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.crane;

import eu.openanalytics.crane.config.CraneConfig;
import eu.openanalytics.crane.service.UserService;
import org.springframework.ui.ModelMap;

public class BaseUIController {
    protected final UserService userService;
    protected final CraneConfig config;

    public BaseUIController(UserService userService, CraneConfig craneConfig) {
        this.userService = userService;
        this.config = craneConfig;
    }

    protected void prepareMap(ModelMap map) {
        boolean authenticated = this.userService.isAuthenticated();
        map.put((Object)"loginUrl", (Object)this.userService.getLoginUrl());
        map.put((Object)"logo", (Object)this.config.getLogoUrl());
        map.put((Object)"authenticated", (Object)authenticated);
        map.put((Object)"isOnlyPublic", (Object)this.config.isOnlyPublic());
        if (authenticated) {
            map.put((Object)"username", (Object)this.userService.getUser().getName());
        }
    }
}

