/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.rdepot.crane.service.spel;

import eu.openanalytics.rdepot.crane.service.spel.SpecExpressionContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.stereotype.Component;

@Component
public class SpecExpressionResolver {
    private final ApplicationContext appContext;
    private final ExpressionParser expressionParser;
    private final Map<SpecExpressionContext, StandardEvaluationContext> evaluationCache = new ConcurrentHashMap(8);
    private final ParserContext beanExpressionParserContext = new /* Unavailable Anonymous Inner Class!! */;

    public SpecExpressionResolver(ApplicationContext appContext) {
        this.appContext = appContext;
        this.expressionParser = new SpelExpressionParser();
    }

    public Object evaluate(String expression, SpecExpressionContext context) {
        if (expression == null) {
            return null;
        }
        if (expression.isEmpty()) {
            return "";
        }
        Expression expr = this.expressionParser.parseExpression(expression, this.beanExpressionParserContext);
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.appContext).getBeanFactory();
        StandardEvaluationContext sec = (StandardEvaluationContext)this.evaluationCache.get(context);
        if (sec == null) {
            sec = new StandardEvaluationContext();
            sec.setRootObject((Object)context);
            sec.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
            sec.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
            sec.addPropertyAccessor((PropertyAccessor)new MapAccessor());
            sec.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
            sec.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.appContext));
            sec.setTypeLocator((TypeLocator)new StandardTypeLocator(beanFactory.getBeanClassLoader()));
            ConversionService conversionService = beanFactory.getConversionService();
            if (conversionService != null) {
                sec.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
            }
            this.evaluationCache.put(context, sec);
        }
        return expr.getValue((EvaluationContext)sec);
    }

    public String evaluateToString(String expression, SpecExpressionContext context) {
        return String.valueOf(this.evaluate(expression, context));
    }

    public Boolean evaluateToBoolean(String expression, SpecExpressionContext context) {
        return Boolean.valueOf(this.evaluateToString(expression, context));
    }
}

