/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.rdepot.crane.service.spel;

import eu.openanalytics.rdepot.crane.model.Repository;
import eu.openanalytics.rdepot.crane.service.AccessControlService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class SpecExpressionContext {
    private Repository repository;
    private List<String> groups;
    private Map<String, Object> claims;

    public List<String> getGroups() {
        return this.groups;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public List<String> toList(String attribute, String regex) {
        if (attribute == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(attribute.split(regex)).map(String::trim).collect(Collectors.toList());
    }

    public List<String> toList(String attribute) {
        return this.toList(attribute, ",");
    }

    public List<String> toLowerCaseList(String attribute, String regex) {
        if (attribute == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(attribute.split(regex)).map(it -> it.trim().toLowerCase()).collect(Collectors.toList());
    }

    public List<String> toLowerCaseList(String attribute) {
        return this.toLowerCaseList(attribute, ",");
    }

    public boolean isOneOf(String attribute, String ... allowedValues) {
        if (attribute == null) {
            return false;
        }
        return Arrays.stream(allowedValues).anyMatch(it -> it.trim().equals(attribute.trim()));
    }

    public boolean isOneOfIgnoreCase(String attribute, String ... allowedValues) {
        if (attribute == null) {
            return false;
        }
        return Arrays.stream(allowedValues).anyMatch(it -> it.trim().equalsIgnoreCase(attribute.trim()));
    }

    public static SpecExpressionContext create(Object ... objects) {
        SpecExpressionContext ctx = new SpecExpressionContext();
        for (Object o : objects) {
            if (o instanceof Repository) {
                ctx.repository = (Repository)o;
            } else if (o instanceof DefaultOidcUser) {
                ctx.claims = ((DefaultOidcUser)o).getClaims();
            } else if (o instanceof JwtAuthenticationToken) {
                ctx.claims = ((Jwt)((JwtAuthenticationToken)o).getToken()).getClaims();
            }
            if (!(o instanceof Authentication)) continue;
            ctx.groups = AccessControlService.getGroups((Authentication)((Authentication)o));
        }
        return ctx;
    }
}

