/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.rdepot.crane.service;

import eu.openanalytics.rdepot.crane.config.CraneConfig;
import eu.openanalytics.rdepot.crane.model.Repository;
import eu.openanalytics.rdepot.crane.service.spel.SpecExpressionContext;
import eu.openanalytics.rdepot.crane.service.spel.SpecExpressionResolver;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class AccessControlService {
    private final CraneConfig craneConfig;
    private final SpecExpressionResolver specExpressionResolver;

    public AccessControlService(CraneConfig craneConfig, SpecExpressionResolver specExpressionResolver) {
        this.craneConfig = craneConfig;
        this.specExpressionResolver = specExpressionResolver;
    }

    public boolean canAccess(Authentication auth, String repositoryName) {
        if (auth == null || repositoryName == null) {
            return false;
        }
        Repository repository = this.craneConfig.getRepository(repositoryName);
        if (repository == null) {
            return false;
        }
        return this.canAccess(auth, repository);
    }

    public boolean canAccess(Authentication auth, Repository repository) {
        if (auth == null || repository == null) {
            return false;
        }
        if (repository.getPublic().booleanValue()) {
            return true;
        }
        if (auth instanceof AnonymousAuthenticationToken) {
            return false;
        }
        if (this.repositoryAllowsAnyLoggedInUser(repository)) {
            return true;
        }
        if (this.allowedByGroups(auth, repository)) {
            return true;
        }
        if (this.allowedByUsers(auth, repository)) {
            return true;
        }
        return this.allowedByExpression(auth, repository);
    }

    public boolean repositoryAllowsAnyLoggedInUser(Repository repository) {
        return !repository.hasGroupAccess() && !repository.hasUserAccess() && !repository.hasExpressionAccess();
    }

    public boolean allowedByGroups(Authentication auth, Repository spec) {
        if (!spec.hasGroupAccess()) {
            return false;
        }
        for (String group : spec.getAccessGroups()) {
            if (!this.isMember(auth, group)) continue;
            return true;
        }
        return false;
    }

    public boolean allowedByUsers(Authentication auth, Repository repository) {
        if (!repository.hasUserAccess()) {
            return false;
        }
        for (String user : repository.getAccessUsers()) {
            if (!auth.getName().equals(user)) continue;
            return true;
        }
        return false;
    }

    public boolean allowedByExpression(Authentication auth, Repository repository) {
        if (!repository.hasExpressionAccess()) {
            return false;
        }
        SpecExpressionContext context = SpecExpressionContext.create((Object[])new Object[]{auth, auth.getPrincipal(), auth.getCredentials(), repository});
        return this.specExpressionResolver.evaluateToBoolean(repository.getAccessExpression(), context);
    }

    public boolean isMember(Authentication auth, String group) {
        for (GrantedAuthority grantedAuth : auth.getAuthorities()) {
            String groupName = grantedAuth.getAuthority().toUpperCase();
            if (groupName.startsWith("ROLE_")) {
                groupName = groupName.substring(5);
            }
            if (!groupName.equalsIgnoreCase(group)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getGroups(Authentication auth) {
        ArrayList<String> groups = new ArrayList<String>();
        if (auth != null) {
            for (GrantedAuthority grantedAuth : auth.getAuthorities()) {
                String authName = grantedAuth.getAuthority().toUpperCase();
                if (authName.startsWith("ROLE_")) {
                    authName = authName.substring(5);
                }
                groups.add(authName);
            }
        }
        return groups;
    }
}

