/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.rdepot.crane.security;

import eu.openanalytics.rdepot.crane.config.CraneConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;

@EnableWebSecurity
public class WebSecurity
extends WebSecurityConfigurerAdapter {
    private final CraneConfig config;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public WebSecurity(CraneConfig config) {
        this.config = config;
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/.well-known/configured-openid-configuration"})).permitAll().antMatchers(new String[]{"/actuator/health"})).anonymous().antMatchers(new String[]{"/actuator/health/readiness"})).anonymous().antMatchers(new String[]{"/actuator/health/liveness"})).anonymous().antMatchers(new String[]{"/{repoName}/**"})).access("@accessControlService.canAccess(authentication, #repoName)").anyRequest()).authenticated().and()).oauth2ResourceServer().jwt().jwkSetUri(this.config.getJwksUri()).jwtAuthenticationConverter((Converter)this.jwtAuthenticationConverter()).and().and()).oauth2Login().userInfoEndpoint().userAuthoritiesMapper((GrantedAuthoritiesMapper)new NullAuthoritiesMapper()).oidcUserService(this.oidcUserService()).and().and()).oauth2Client();
    }

    private OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private JwtAuthenticationConverter jwtAuthenticationConverter() {
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        converter.setJwtGrantedAuthoritiesConverter(jwt -> {
            if (!this.config.hasOpenidGroupsClaim()) {
                return new ArrayList();
            }
            Object claimValue = jwt.getClaims().get(this.config.getOpenidGroupsClaim());
            return this.mapAuthorities(claimValue);
        });
        converter.setPrincipalClaimName(this.config.getOpenidUsernameClaim());
        return converter;
    }

    private Set<GrantedAuthority> mapAuthorities(Object claimValue) {
        HashSet<GrantedAuthority> mappedAuthorities = new HashSet<GrantedAuthority>();
        for (String role : this.parseGroupsClaim(claimValue)) {
            Object mappedRole = role.toUpperCase().startsWith("ROLE_") ? role : "ROLE_" + role;
            mappedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(((String)mappedRole).toUpperCase()));
        }
        return mappedAuthorities;
    }

    private List<String> parseGroupsClaim(Object claimValue) {
        String groupsClaimName = this.config.getOpenidGroupsClaim();
        if (claimValue == null) {
            this.logger.debug(String.format("No groups claim with name %s found", groupsClaimName));
            return new ArrayList<String>();
        }
        this.logger.debug(String.format("Matching claim found: %s -> %s (%s)", groupsClaimName, claimValue, claimValue.getClass()));
        if (claimValue instanceof Collection) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object object : (Collection)claimValue) {
                if (object == null) continue;
                result.add(object.toString());
            }
            this.logger.debug(String.format("Parsed groups claim as Java Collection: %s -> %s (%s)", groupsClaimName, result, result.getClass()));
            return result;
        }
        if (claimValue instanceof String) {
            ArrayList<String> result = new ArrayList<String>();
            try {
                Object value = new JSONParser(-1).parse((String)claimValue);
                if (value instanceof List) {
                    List valueList = (List)value;
                    valueList.forEach(o -> result.add(o.toString()));
                }
            }
            catch (ParseException e) {
                this.logger.debug(String.format("Unable to parse claim as JSON: %s -> %s (%s)", groupsClaimName, claimValue, claimValue.getClass()));
            }
            this.logger.debug(String.format("Parsed groups claim as JSON: %s -> %s (%s)", groupsClaimName, result, result.getClass()));
            return result;
        }
        this.logger.debug(String.format("No parser found for groups claim (unsupported type): %s -> %s (%s)", groupsClaimName, claimValue, claimValue.getClass()));
        return new ArrayList<String>();
    }
}

