/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.rdepot.crane.model;

import java.util.List;
import java.util.regex.Pattern;

public class Repository {
    private String name;
    private List<String> accessGroups;
    private List<String> accessUsers;
    private String accessExpression;
    private Boolean isPublic = false;
    private static final Pattern namePattern = Pattern.compile("^[a-zA-Z0-9_\\-]*$");

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAccessGroups() {
        return this.accessGroups;
    }

    public void setAccessGroups(List<String> accessGroups) {
        this.accessGroups = accessGroups;
    }

    public List<String> getAccessUsers() {
        return this.accessUsers;
    }

    public void setAccessUsers(List<String> accessUsers) {
        this.accessUsers = accessUsers;
    }

    public String getAccessExpression() {
        return this.accessExpression;
    }

    public void setAccessExpression(String accessExpression) {
        this.accessExpression = accessExpression;
    }

    public boolean hasGroupAccess() {
        return this.accessGroups != null && this.accessGroups.size() > 0;
    }

    public boolean hasUserAccess() {
        return this.accessUsers != null && this.accessUsers.size() > 0;
    }

    public boolean hasExpressionAccess() {
        return this.accessExpression != null && this.accessExpression.length() > 0;
    }

    public Boolean getPublic() {
        return this.isPublic;
    }

    public void setPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void validate() {
        if (this.name == null) {
            throw new RuntimeException("Repository has no name");
        }
        if (!namePattern.matcher(this.name).matches()) {
            throw new RuntimeException(String.format("Repository name %s contains invalid characters", this.name));
        }
        if (this.isPublic.booleanValue() && (this.hasGroupAccess() || this.hasUserAccess() || this.hasExpressionAccess())) {
            throw new IllegalArgumentException(String.format("Repository %s is invalid, cannot add access control properties to a public repo", this.name));
        }
    }
}

