/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.rdepot.crane.config;

import eu.openanalytics.rdepot.crane.model.Repository;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConfigurationProperties(prefix="app")
public class CraneConfig {
    private String storageLocation;
    private String openidIssuerUri;
    private String openidGroupsClaim;
    private String openidUsernameClaim = "preferred_username";
    private Map<String, Repository> repositories = new HashMap();
    private static final String OIDC_METADATA_PATH = "/.well-known/openid-configuration";

    @PostConstruct
    public void init() {
        if (this.storageLocation == null) {
            throw new IllegalArgumentException("Incorrect configuration detected: app.storage-location not set");
        }
        if (this.openidIssuerUri == null) {
            throw new IllegalArgumentException("Incorrect configuration detected: app.openid-issuer-uri not set");
        }
        if (this.repositories.size() == 0) {
            throw new IllegalArgumentException("Incorrect configuration detected: no repositories configured");
        }
        this.repositories.values().forEach(Repository::validate);
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        if (!storageLocation.startsWith("/") || !storageLocation.endsWith("/")) {
            throw new IllegalArgumentException("Incorrect configuration detected: app.storage-location must start and end with /");
        }
        File path = new File(storageLocation);
        if (!path.exists() || !path.isDirectory()) {
            throw new IllegalArgumentException("Incorrect configuration detected: app.storage-location does not exists or is not a directory");
        }
        this.storageLocation = storageLocation;
    }

    public String getOpenidIssuerUri() {
        return this.openidIssuerUri;
    }

    public void setOpenidIssuerUri(String openidIssuerUri) {
        this.openidIssuerUri = openidIssuerUri;
    }

    public String getJwksUri() {
        ClientRegistration clientRegistration = ClientRegistrations.fromIssuerLocation((String)this.getOpenidIssuerUri()).clientId("bogus").build();
        return clientRegistration.getProviderDetails().getJwkSetUri();
    }

    public String getConfiguredOpenIdMetadataUrl() {
        URI issuer = URI.create(this.openidIssuerUri);
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(issuer.getPath() + OIDC_METADATA_PATH).build(Collections.emptyMap()).toString();
    }

    public Collection<Repository> getRepositories() {
        return this.repositories.values();
    }

    public Repository getRepository(String name) {
        return (Repository)this.repositories.get(name);
    }

    public void setRepositories(List<Repository> repositories) {
        this.repositories = repositories.stream().collect(Collectors.toMap(Repository::getName, it -> it));
    }

    public boolean hasOpenidGroupsClaim() {
        return this.openidGroupsClaim != null && !this.openidGroupsClaim.isEmpty();
    }

    public void setOpenidGroupsClaim(String openidGroupsClaim) {
        this.openidGroupsClaim = openidGroupsClaim;
    }

    public String getOpenidGroupsClaim() {
        return this.openidGroupsClaim;
    }

    public String getOpenidUsernameClaim() {
        return this.openidUsernameClaim;
    }

    public void setOpenidUsernameClaim(String openidUsernameClaim) {
        this.openidUsernameClaim = openidUsernameClaim;
    }
}

